program DataReader;

{$APPTYPE CONSOLE}

{%DelphiDotNetAssemblyCompiler '$(CommonProgramFiles)\borland shared\bds\shared assemblies\3.0\Borland.Data.Common.dll'}
{%DelphiDotNetAssemblyCompiler '$(CommonProgramFiles)\borland shared\bds\shared assemblies\3.0\Borland.Data.Provider.dll'}
{%DelphiDotNetAssemblyCompiler '$(SystemRoot)\microsoft.net\framework\v1.1.4322\System.Data.dll'}

uses
  SysUtils,
  Borland.Data.Provider,
  Borland.Data.Common,
  System.Data;

var s_conn, s_table : string;
    bdp_conn : BdpConnection;
    bdp_comm : BdpCommand;
    bdp_dr : BdpDataReader;

type
  ArrayOfByte = array of Byte;
  ArrayOfChar = array of Char;

procedure GetData( i_reader : IDataReader );
var t : System.Type;
    buffSize : Integer;
    bytes : ArrayOfByte;
    chars : ArrayOfChar;
    index : Integer;
begin

			try
        begin
          for index := 0 to i_reader.FieldCount - 1 do
          begin

            if i_reader.IsDBNull(index) then
						  Console.Write('NULL')
					  else
              begin
                t :=  i_reader.GetFieldType(index);
                if t = typeof(Int16) then
							    Console.Write(i_reader.GetInt16(index))
						    else if t = typeof(Int32) then
							    Console.Write(i_reader.GetInt32(index))
						    else if t = typeof(String) then
							    Console.Write(i_reader.GetString(index))
						    else if t = typeof(single) then
							    Console.Write(i_reader.GetFloat(index))
						    else if t = typeof(double) then
							    Console.Write(i_reader.GetDouble(index))
						    else if t = typeof(DateTime) then
							    Console.Write(i_reader.GetDateTime(index))
						    else if t = typeof(Decimal) then
							    Console.Write(i_reader.GetDecimal(index))
						    else if t = typeof(ArrayOfByte) then
                  begin

							      buffSize := Integer(i_reader.GetBytes(index, 0, nil, 0, 0));
                    SetLength(bytes, buffSize);

							      {if i_reader.GetBytes(index, 0, buffer, 0, buffSize) <> 0 then
								      Console.Write( 'Blob Data: ' + buffer.Length + ' bytes');}

						      end
						    else if t = typeof(ArrayOfChar) then
                  begin
	    						  buffSize := Integer(i_reader.GetChars(index, 0, nil, 0, 0));
                    SetLength( chars, buffSize );

    							  {if i_reader.GetChars(index, 0, chars, 0, buffSize) <> 0 then
      								Console.Write('Clob Data: ' + charbuf.Length + ' chars');}

                  end
    						else
		    					Console.Write('Unknown DataType');
              end;

					  if (index < i_reader.FieldCount -1) and (index >= 0) then
						  Console.Write(', ');

          end;

      end
        except
          on e : Exception do
          begin
      			Console.Write('Exception caught:' + e.Message);
			    end;
      end;

			Console.WriteLine();

end;

begin

  if ParamCount > 0 then
    s_table := ParamStr(1)
  else
    s_table := 'EMPLOYEE';

  // Create the connection string and BdpConnection
	s_conn := 'assembly=Borland.Data.Interbase,Version=2.5.0.0,Culture=neutral,PublicKeyToken=91d62ebb5b0d1b1b;vendorclient=gds32.dll;database=localhost:C:\\Program Files\\Common Files\\Borland Shared\\data\\employee.gdb;provider=Interbase;username=sysdba;password=masterkey';
  bdp_conn := BdpConnection.Create( s_conn );

	bdp_comm := BdpCommand.Create('select * from ' + s_table, bdp_conn);

	bdp_conn.Open();
	bdp_dr := bdp_comm.ExecuteReader();

	while bdp_dr.Read() do
	  GetData( bdp_dr );

end.
